/**************************************************************************************************************************
 Program Name:Account.java
 Programmers Name:Stella Irungu
 Program Description:Implement an inheritance hierarchy based on the following specifications for Account class, Checking
 					  Account class, and Savings Account class
 ***************************************************************************************************************************/
public class Account {
	//attributes
	private static String accountName;
	private static int accountID;
	private static double balance;
	
	//initialize balance to zero
	public Account()
	{
		balance = 0;
	}
	//accepts the parameter deposit amount and updates the balance by adding the deposit amount to the balance
	public static void processDeposit(double deposit)
	{	
		balance = balance + deposit;
		System.out.println("Amount to deposit: " + deposit);
		System.out.println("Balance: "+ balance);
		
	}
	//accepts  the parameter withdrawal amount and updates the balance by subtracting the withdrawal amount for the 
	//balance
	public static void processWithdrawl(double withdrawal)
	{
		balance = balance - withdrawal;
		System.out.println("Amount to withdrawal: "+ withdrawal);
		System.out.println("Balance: "+ balance);
	}
	//set and get for name, accountID
	public static String getName(String accountName)
	{
		return accountName;
	}
	public static int getID(int accountID)
	{
		return accountID;
		
	}
	// getBalance to return balance
	public static double getBalance(double balance)
	{	
		return balance;
	}
	public static void displayAccount()
	{
		System.out.println("Account: " + getID(2345));
		System.out.println("Name: "+ getName("John Smith"));
		System.out.println("Balance: " + getBalance(120.75));
	}
	//Checking account class is derived from account class
	public static class CheckingAcct extends Account {
		
		//needs to be overriden so that if the withdrawal causes insufficient funds, subtract $10 overdraft fee and 
		//display a message "overdraft fee charged"
		public static void processWithdrawl(double withdrawl)
		{
			if (balance < 0)
				System.out.println(" $10 overdrafted fee charged!");
		}
		public static void displayAccount()
		{
			System.out.println("Account type: Checking ");
			System.out.println("Account: " + getID(2345));
			System.out.println("Name: "+ getName("John Smith"));
			System.out.println("Balance: "+ getBalance(120.75));
		}
	}
	// Savings account is derived from account class
	public static class SavingsAcct extends Account{
		
		//needs to be overriden so that if the withdrawl causes insufficient funds, a message "insufficient funds" is 
		//displayed a no withdrawl is made.
		public static void processWithrawl(double withdrawl)
		{
			if(balance <0)
				System.out.println("insufficient funds");
		}
		public static double calcInterest()
		{
			double rate;
			if(balance >= 5000.00)
				rate = balance * 0.04;
			else if (balance >= 3000.00)
				rate = balance * 0.03;
			else
				rate = balance * 0.02;
			
			return rate;
		}
		public static void displayAccount()
		{
			System.out.println("Account type: Savings ");
			System.out.println("Account: "+ getID(2345));
			System.out.println("Name: "+ getName("John Smith"));
			System.out.println("Interest earned:" + calcInterest());
			System.out.println("Balance: " + getBalance(250.75));
		}
	}
	public static void main(String [] args)
	{
		//create an arraylist of account type that can handle Checking and Savings accounts(this is the Bank)
		String[] Bank = {"CheckingAcct", "SavingsAcct"};
		
		//Use a loop to process all accounts USING THE BANK array
		for(int i=0; i<Bank.length; i++)
		{
			//prompt name, account number
			System.out.println("Creating a checking account, enter name: " + getName("John Smith"));
			System.out.println("Your checking account number is " + getID(2345));
			System.out.println("Creating a savings account enter name: "+ getName("Sue Johnson"));
			System.out.println("Your savings account number is "+ getID(1001));
			processDeposit(50.00);
			processWithdrawl(25.00);
			displayAccount();
			
		}
	}

}
